% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_cai_mn.R
\name{lsm_l_cai_mn}
\alias{lsm_l_cai_mn}
\alias{lsm_l_cai_mn.RasterLayer}
\alias{lsm_l_cai_mn.RasterStack}
\alias{lsm_l_cai_mn.RasterBrick}
\alias{lsm_l_cai_mn.stars}
\alias{lsm_l_cai_mn.list}
\title{CAI_MN (landscape level)}
\usage{
lsm_l_cai_mn(landscape, directions, consider_boundary, edge_depth)

\method{lsm_l_cai_mn}{RasterLayer}(landscape, directions = 8,
  consider_boundary = FALSE, edge_depth = 1)

\method{lsm_l_cai_mn}{RasterStack}(landscape, directions = 8,
  consider_boundary = FALSE, edge_depth = 1)

\method{lsm_l_cai_mn}{RasterBrick}(landscape, directions = 8,
  consider_boundary = FALSE, edge_depth = 1)

\method{lsm_l_cai_mn}{stars}(landscape, directions = 8,
  consider_boundary = FALSE, edge_depth = 1)

\method{lsm_l_cai_mn}{list}(landscape, directions = 8,
  consider_boundary = FALSE, edge_depth = 1)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Mean of core area index (Core area metric)
}
\details{
\deqn{CAI_{MN} = mean(CAI[patch_{ij}]}
where \eqn{CAI[patch_{ij}]} is the core area index of each patch.

CAI_MN is a 'Core area metric'. The metric summarises the landscape
as the mean of the core area index of all patches in the landscape.
The core area index is the percentage of core area in relation to patch area.
A cell is defined as core area if the cell has no neighbour with a different
value than itself (rook's case).

\subsection{Units}{Percent}
\subsection{Range}{CAI_MN >= 0}
\subsection{Behaviour}{Equals CAI_MN = 0 if CAI = 0 for all patches. Increases,
without limit, as the core area indices increase.}
}
\examples{
lsm_l_cai_mn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_cai}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_cai_sd}},
\code{\link{lsm_c_cai_sd}},
\code{\link{lsm_c_cai_cv}}, \cr
\code{\link{lsm_l_cai_sd}},
\code{\link{lsm_l_cai_cv}}
}
