% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_dcore_cv.R
\name{lsm_l_dcore_cv}
\alias{lsm_l_dcore_cv}
\title{DCORE_CV (landscape level)}
\usage{
lsm_l_dcore_cv(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Coefficient of variation number of disjunct core areas (Core area metric)
}
\details{
\deqn{DCORE_{CV} = cv(NCORE[patch_{ij}])}
where \eqn{NCORE[patch_{ij}]} is the number of core areas.

DCORE_CV is an 'Core area metric'. It summarises the landscape as the Coefficient
of variation of all patches belonging to the landscape. A cell is defined as core if
the cell has no neighbour with a different value than itself (rook's case). NCORE counts
the disjunct core areas, whereby a core area is a 'patch within the patch' containing
only core cells. The metric describes the differences among all patches in the landscape
and is easily comparable because it is scaled to the mean.

\subsection{Units}{None}
\subsection{Range}{DCORE_CV >= 0}
\subsection{Behaviour}{Equals DCORE_CV = 0 if all patches have the same number of disjunct
core areas. Increases, without limit, as the variation of number of disjunct core areas
increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_dcore_cv(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_p_ncore}}, \cr
\code{\link{lsm_c_dcore_mn}},
\code{\link{lsm_c_dcore_sd}},
\code{\link{lsm_c_dcore_cv}}, \cr
\code{\link{lsm_l_dcore_mn}},
\code{\link{lsm_l_dcore_sd}}
}
