% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_area.R
\name{lsm_p_area}
\alias{lsm_p_area}
\title{AREA (patch level)}
\usage{
lsm_p_area(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch area (Area and edge metric)
}
\details{
\deqn{AREA = a_{ij} * (\frac{1} {10000})}
where \eqn{a_{ij}} is the area in square meters.

AREA is an 'Area and edge metric' and equals the area of each patch in hectares.
The lower limit of AREA is limited by the resolution of the input raster,
i.e. AREA can't be smaller than the resolution squared (in hectares). It is one of
the most basic, but also most important metrics, to characterise a landscape. The
metric is the simplest measure of composition.

\subsection{Units}{Hectares}
\subsection{Range}{AREA > 0}
\subsection{Behaviour}{Increases, without limit, as the patch size increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_p_area(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_c_area_mn}},
\code{\link{lsm_c_area_sd}},
\code{\link{lsm_c_area_cv}},
\code{\link{lsm_c_ca}}, \cr
\code{\link{lsm_l_area_mn}},
\code{\link{lsm_l_area_sd}},
\code{\link{lsm_l_area_cv}},
\code{\link{lsm_l_ta}}
}
