% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_circumscribingcircle.R
\name{get_circumscribingcircle}
\alias{get_circumscribingcircle}
\title{get_circumscribingcircle}
\usage{
get_circumscribingcircle(landscape, directions = 8, level = "patch")
}
\arguments{
\item{landscape}{SpatRaster or matrix (with x, y, id columns)}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{level}{Either 'patch' or 'class' for the corresponding level.}
}
\description{
Diameter of the circumscribing circle around patches
}
\details{
The diameter of the smallest circumscribing circle around a patch in the landscape
is based on the maximum distance between the corners of each cell. This ensures that all
cells of the patch are included in the patch.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)

# get circle around each patch
get_circumscribingcircle(landscape)

# get circle around whole class
get_circumscribingcircle(landscape, level = "class")

}
\references{
Based on C++ code from Project Nayuki (https://www.nayuki.io/page/smallest-enclosing-circle).
}
