% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_circle.R
\name{lsm_p_circle}
\alias{lsm_p_circle}
\title{CIRCLE (patch level)}
\usage{
lsm_p_circle(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Related Circumscribing Circle (Shape metric)
}
\details{
\deqn{CIRCLE = 1 - (\frac{a_{ij}} {a_{ij}^{circle}})}
where \eqn{a_{ij}} is the area in square meters and \eqn{a_{ij}^{circle}} the area of
the smallest circumscribing circle.

CIRCLE is a 'Shape metric'. The metric is the ratio between the patch area and the smallest
circumscribing circle of the patch. The diameter of the smallest circumscribing circle is
the 'diameter' of the patch connecting the opposing corner points of the two cells
that are the furthest away from each other. The metric characterises the compactness
of the patch and is comparable among patches with different area.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{None}
\subsection{Range}{0 <= CIRCLE < 1}
\subsection{Behaviour}{CIRCLE = 0 for a circular patch and approaches CIRCLE = 1 for
a linear patch.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_p_circle(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Baker, W. L., and Y. Cai. 1992. The r.le programs for multiscale analysis of
landscape structure using the GRASS geographical information system.
Landscape Ecology 7: 291-302.

Based on C++ code from Project Nayuki (https://www.nayuki.io/page/smallest-enclosing-circle).
}
\seealso{
\code{\link{lsm_p_area}}, \cr
\code{\link{lsm_c_circle_mn}},
\code{\link{lsm_c_circle_sd}},
\code{\link{lsm_c_circle_cv}}, \cr
\code{\link{lsm_l_circle_mn}},
\code{\link{lsm_l_circle_sd}},
\code{\link{lsm_l_circle_cv}}
}
