% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_division.R
\name{lsm_c_division}
\alias{lsm_c_division}
\title{DIVISION (class level)}
\usage{
lsm_c_division(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Landscape division index (Aggregation metric)
}
\details{
\deqn{DIVISON = (1 - \sum \limits_{j = 1}^{n} (\frac{a_{ij}} {A}) ^ 2)}
where \eqn{a_{ij}} is the area in square meters and \eqn{A} is the total
landscape area in square meters.

DIVISION is an 'Aggregation metric. It can be in as the probability that two
randomly selected cells are not located in the same patch of class i. The landscape
division index is negatively correlated with the  effective mesh size  (\code{\link{lsm_c_mesh}}).

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{Proportion }
\subsection{Ranges}{0 <= Division < 1}
\subsection{Behaviour}{Equals DIVISION = 0 if only one patch is present. Approaches
DIVISION = 1 if all patches of class i are single cells.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_division(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Jaeger, J. A. 2000. Landscape division, splitting index, and effective mesh
size: new measures of landscape fragmentation.
Landscape ecology, 15(2), 115-130.
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_l_division}}
}
