% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/languageserver_add_to_rprofile.R
\name{languageserver_add_to_rprofile}
\alias{languageserver_add_to_rprofile}
\title{Add language server initialization to \code{.Rprofile}}
\usage{
languageserver_add_to_rprofile(rlsLib = getOption("langserver_library"),
  rprofilePath = locate_rprofile(), confirmBeforeChanging = TRUE,
  code = append_code(rlsLib = rlsLib))
}
\arguments{
\item{rlsLib}{\code{character(1)} path to the library.}

\item{rprofilePath}{\code{character(1)}, path to the file where
to add the initialization code, or \code{NULL}. By default, adds the
code to a \code{.Rprofile} file in the home directory of the current
user. Please refer to \code{?Startup} for more details around
\code{.Rprofile} files.

Notably, if  the \code{R_PROFILE_USER} environment variable is set,
the \code{.Rprofile} located in the home directory is ignored,
therefore we may want to place the initialization code into the
file specified by that variable using the \code{rprofilePath} argument
in that case.}

\item{confirmBeforeChanging}{\code{logical(1)}, if \code{TRUE}, asks for user
confirmation before changing the file. For non-interactive
use, \code{FALSE} will skip the confirmation.}

\item{code}{\code{character()}, the code to be added to the file.
Defaults to the value of \code{append_code()}.}
}
\value{
side-effects
}
\description{
Add language server initialization to \code{.Rprofile}
}
