% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_mining.R
\name{sentimentBreakdown}
\alias{sentimentBreakdown}
\title{Sentiment Breakdown on Text}
\usage{
sentimentBreakdown(
  text,
  lang = "spanish",
  exclude = c("maduro", "que"),
  append_file = NA,
  append_words = NA,
  plot = TRUE,
  subtitle = NA
)
}
\arguments{
\item{text}{Character vector}

\item{lang}{Character. Language in text (used for stop words)}

\item{exclude}{Character vector. Which word do you wish to exclude?}

\item{append_file}{Character. Add a dictionary to append. This file
must contain at least two columns, first with words and second with
the sentiment (consider sentiments on description).}

\item{append_words}{Dataframe. Same as append_file but appending
data frame with word and sentiment directly}

\item{plot}{Boolean. Plot results summary?}

\item{subtitle}{Character. Add subtitle to the plot}
}
\value{
List. Contains data.frame with words and sentiments, summary and plot.
}
\description{
This function searches for relevant words in a given text and adds
sentiments labels (joy, anticipation, surprise, positive, trust,
anger, sadness, fear, negative, disgust) for each of them, using NRC.
Then, makes a summary for all words and plot results.
}
\seealso{
Other Text Mining: 
\code{\link{cleanNames}()},
\code{\link{cleanText}()},
\code{\link{ngrams}()},
\code{\link{remove_stopwords}()},
\code{\link{replaceall}()},
\code{\link{textCloud}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{topics_rake}()}
}
\concept{Text Mining}
