% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{quants}
\alias{quants}
\title{Calculate cuts by quantiles}
\usage{
quants(values, splits = 10, return = "labels", n = 2)
}
\arguments{
\item{values}{Vector. Values to calculate quantile cuts}

\item{splits}{Integer. How many cuts should split the values?}

\item{return}{Character. Return "summary" or "labels"}

\item{n}{Integer. Determines the number of digits used in
formatting the break numbers.}
}
\value{
Factor vector or data.frame. Depending on \code{return} input:
\itemize{
  \item \code{labels} a factor ordered vector with each observation's quantile
  \item \code{summary} a data.frame with information on each quantile cut
}
}
\description{
This function lets the user quickly calculate cuts for quantiles
and discretize numerical values into categorical values.
}
\examples{
data(dft) # Titanic dataset
quants(dft$Age, splits = 5, "summary")
quants(dft$Age, splits = 5, "labels")[1:10]
}
\seealso{
Other Calculus: 
\code{\link{corr}()},
\code{\link{dist2d}()},
\code{\link{model_metrics}()}
}
\concept{Calculus}
