% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slack.R
\name{slackSend}
\alias{slackSend}
\title{Send Slack Message (Webhook)}
\usage{
slackSend(text, title = "", pretext = "", hook = NA, creds = NA)
}
\arguments{
\item{text, title, pretext}{Character. Content on you Slack message.}

\item{hook}{Character. Web hook URL. Ths value will be overwritten by
creds if correctly used.}

\item{creds}{Character. Credential's dir (see \code{get_creds()}). Set
hook URL into the "slack" list in your YML file. Will use first value.}
}
\value{
Invisible POST response
}
\description{
This function send a Slack message using its Webhooks.
}
\details{
For more help, you can follow the
\href{https://api.slack.com/messaging/webhooks#posting_with_webhooks}{Sending messages using Incoming Webhooks}
original documentarion.
}
\examples{
\dontrun{
slackSend(text = "This is a message", title = "TEST", pretext = Sys.info()["user"])
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_posts}()},
\code{\link{fb_post}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{queryGA}()}

Other Credentials: 
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{get_credentials}()},
\code{\link{get_tweets}()},
\code{\link{mail_send}()},
\code{\link{queryDB}()},
\code{\link{queryGA}()},
\code{\link{stocks_file}()},
\code{\link{stocks_report}()}
}
\concept{API}
\concept{Credentials}
