% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{formatColoured}
\alias{formatColoured}
\title{Print Coloured Messages}
\usage{
formatColoured(
  txt,
  colour = c("yellow", "blue", "grey"),
  bold = FALSE,
  cat = TRUE
)
}
\arguments{
\item{txt}{Character. Text to print or transform.}

\item{colour}{Character. Any of: grey, red, green, yellow, blue, or purple.}

\item{bold}{Boolean. Set bold text?}

\item{cat}{Boolean. Print with cat? If not, raw string}
}
\value{
Depends on \code{cat}: NULL if TRUE or character string if FALSE.
}
\description{
Print Coloured Messages
}
\examples{
opts <- c("GREY", "RED", "GREEN", "YELLOW", "BLUE", "PURPLE")
for (colour in opts) formatColoured(paste("Colour:", colour, "\n"), colour)
formatColoured("my bold coloured text", bold = TRUE, cat = TRUE)
}
