% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outlier_zscore}
\alias{outlier_zscore}
\title{Outliers: Z-score method}
\usage{
outlier_zscore(x, thresh = 3, mad = FALSE)
}
\arguments{
\item{x}{Numeric. Distribution}

\item{thresh}{Numeric. Z-Score threshold for n standard deviations.}

\item{mad}{Boolean. Use median absolute deviation instead?}
}
\value{
data.frame. Each row is an \code{x} observation with its
respective std/mean or mad/med calculations depending on \code{mad} input.
}
\description{
Z-score, also called a standard score, of an observation is a
distance from the population center measured in number of normalization
units. The default choice for center is sample mean and for
normalization unit is standard deviation. Values are considered
outliers based on z-score if its absolute value of
default z-score is higher then the threshold (popular choice is 3).
}
\seealso{
Other Outliers: 
\code{\link{outlier_turkey}()},
\code{\link{outlier_zscore_plot}()},
\code{\link{winsorize}()}
}
\concept{Outliers}
