% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatgpt.R
\name{gpt_ask}
\alias{gpt_ask}
\alias{gpt_history}
\alias{gpt_table}
\alias{gpt_classify}
\alias{gpt_tag}
\alias{gpt_extract}
\alias{gpt_format}
\alias{gpt_convert}
\alias{gpt_translate}
\title{ChatGPT API Interaction with R}
\usage{
gpt_ask(
  ask,
  secret_key = get_credentials()$openai$secret_key,
  url = Sys.getenv("LARES_GPT_URL"),
  model = Sys.getenv("LARES_GPT_MODEL"),
  num_retries = 3,
  temperature = 0.5,
  max_tokens = NULL,
  pause_base = 1,
  quiet = FALSE,
  ...
)

gpt_history(quiet = TRUE, ...)

gpt_table(x, cols = NULL, quiet = TRUE, ...)

gpt_classify(x, categories, quiet = TRUE, ...)

gpt_tag(x, tags, quiet = TRUE, ...)

gpt_extract(x, extract, quiet = TRUE, ...)

gpt_format(x, format, quiet = TRUE, ...)

gpt_convert(x, unit, quiet = TRUE, ...)

gpt_translate(x, language, quiet = TRUE, ...)
}
\arguments{
\item{ask}{Character. Redacted prompt to ask. If multiple asks are
requested, they will be concatenated with "+" into a single request.}

\item{secret_key}{Character. Secret Key. Get yours in:
\href{https://platform.openai.com}{platform.openai.com} for OpenAI or
\href{https://makersuite.google.com/app/apikey}{makersuite.google.com}
for Gemini.}

\item{url}{Character. Base API URL.}

\item{model}{Character. OpenAI model to use. This can be adjusted
according to the available models in the OpenAI API (such as "gpt-4").}

\item{num_retries}{Integer. Number of times to retry the request in
case of failure. Default is 3.}

\item{temperature}{Numeric. The temperature to use for generating
the response. Default is 0.5. The lower the \code{temperature},
the more deterministic the results in the sense that the highest probable
next token is always picked. Increasing temperature could lead to more
randomness, which encourages more diverse or creative outputs. You are
essentially increasing the weights of the other possible tokens.
In terms of application, you might want to use a lower temperature value
for tasks like fact-based QA to encourage more factual and concise responses.
For poem generation or other creative tasks, it might be beneficial to
increase the temperature value.}

\item{max_tokens}{Integer. The maximum number of tokens in the response.}

\item{pause_base}{Numeric. The number of seconds to wait between retries.
Default is 1.}

\item{quiet}{Boolean. Keep quiet? If not, show informative messages.}

\item{...}{Additional parameters.}

\item{x}{Vector. List items you wish to process in your instruction}

\item{cols}{Vector. Force column names for your table results.}

\item{categories, tags}{Vector. List of possible categories/tags to consider.}

\item{extract, format, unit}{Character. Length 1 or same as x to extract/format/unit
information from x. For example: email, country of phone number, country, amount as number,
currency ISO code, ISO, Fahrenheit, etc.}

\item{language}{Character. Language to translate to}
}
\value{
(Invisible) list. Content returned from API POST and processed.
}
\description{
This function lets the user ask ChatGPT via its API, and returns
the rendered reply. There are a couple of specific verbs (functions) with a
preset prompt to help fetch the data in specific formats. We also
store the prompts and replies in current session with their respective
time-stamps so user can gather historical results.
}
\examples{
\dontrun{
api_key <- get_credentials()$openai$secret_key
# Open question:
gpt_ask("Can you write an R function to plot a dummy histogram?", api_key)

##### The following examples return dataframes:
# Classify each element based on categories:
gpt_classify(1:10, c("odd", "even"))

# Add all tags that apply to each element based on tags:
gpt_tag(
  c("I love chocolate", "I hate chocolate", "I like Coke"),
  c("food", "positive", "negative", "beverage")
)

# Extract specific information:
gpt_extract(
  c("My mail is 123@test.com", "30 Main Street, Brooklyn, NY, USA", "+82 2-312-3456", "$1.5M"),
  c("email", "full state name", "country of phone number", "amount as number")
)

# Format values
gpt_format(
  c("March 27th, 2021", "12-25-2023 3:45PM", "01.01.2000", "29 Feb 92"),
  format = "ISO Date getting rid of time stamps"
)

# Convert temperature units
gpt_convert(c("50C", "300K"), "Fahrenheit")

# Create a table with data
gpt_table("5 random people's address in South America, email, phone, age between 18-30")
gpt_table(
  ask = "5 largest cities, their countries, and population",
  cols = c("city_name", "where", "POP")
)

# Translate text to any language
gpt_translate(
  rep("I love you with all my heart", 5),
  language = c("spanish", "chinese", "japanese", "russian", "german")
)

# Now let's read the historical prompts, replies, ano more from current session
gpt_history()
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_process}()},
\code{\link{fb_report_check}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{gemini_ask}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other ChatGPT: 
\code{\link{gpt_prompter}()}

Other LLM: 
\code{\link{gemini_ask}()},
\code{\link{gpt_prompter}()}
}
\concept{API}
\concept{ChatGPT}
\concept{LLM}
