% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predictForCluster}
\alias{predictForCluster}
\alias{predictForCluster,lcModel-method}
\title{lcModel prediction for a specific cluster}
\usage{
\S4method{predictForCluster}{lcModel}(object, newdata = NULL, cluster, ..., what = "mu")
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{newdata}{Optional \code{data.frame} for which to compute the model predictions. If omitted, the model training data is used.
Cluster trajectory predictions are made when ids are not specified.}

\item{cluster}{The cluster name (as \code{character}) to predict for.}

\item{...}{Additional arguments.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}
}
\value{
A \code{vector} with the predictions per \code{newdata} observation, or a \code{data.frame} with the predictions and newdata alongside.
}
\description{
Predicts the expected trajectory observations at the given time under the assumption that the trajectory belongs to the specified cluster.
}
\seealso{
\link{predict.lcModel}

Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()},
\code{\link{trajectories}()}
}
\concept{model-specific methods}
