% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R, R/model.R
\name{plotClusterTrajectories}
\alias{plotClusterTrajectories}
\alias{plotClusterTrajectories,data.frame-method}
\alias{plotClusterTrajectories,lcModel-method}
\title{Plot cluster trajectories}
\usage{
\S4method{plotClusterTrajectories}{data.frame}(
  object,
  response,
  cluster = "Cluster",
  time = getOption("latrend.time"),
  center = meanNA,
  trajectories = c(FALSE, "sd", "se", "80pct", "90pct", "95pct", "range"),
  facet = !isFALSE(as.logical(trajectories[1])),
  id = getOption("latrend.id"),
  ...
)

\S4method{plotClusterTrajectories}{lcModel}(
  object,
  what = "mu",
  at = time(object),
  clusterLabels = NULL,
  trajectories = FALSE,
  facet = !isFALSE(as.logical(trajectories[1])),
  trajAssignments = trajectoryAssignments(object),
  ...
)
}
\arguments{
\item{object}{The (cluster) trajectory data.}

\item{response}{The response variable name.}

\item{cluster}{The cluster assignment column}

\item{time}{The time variable name.}

\item{center}{A function for aggregating multiple points at the same point in time}

\item{trajectories}{Whether to additionally plot the original trajectories (\code{TRUE}),
or to show the expected interval (standard deviation, standard error, range, or percentile range) of the observations at the respective moment in time.

Note that visualizing the expected intervals is currently only supported for time-aligned trajectories, as the interval is computed at each unique moment in time.
By default (\code{FALSE}), no information on the underlying trajectories is shown.}

\item{facet}{Whether to facet by cluster. This is done by default when \code{trajectories} is enabled.}

\item{id}{Id column. Only needed when \code{trajectories = TRUE}.}

\item{...}{Arguments passed to \code{\link[=clusterTrajectories]{clusterTrajectories()}}, or \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}} for plotting the cluster trajectory lines.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}

\item{at}{An optional vector of the times at which to compute the cluster trajectory predictions.}

\item{clusterLabels}{Cluster display names. By default it's the cluster name with its proportion enclosed in parentheses.}

\item{trajAssignments}{The cluster assignments for the fitted trajectories. Only used when \code{trajectories = TRUE} and \code{facet = TRUE}. See \link{trajectoryAssignments}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot cluster trajectories

Plot the cluster trajectories of a lcModel
}
\examples{
data(latrendData)
model <- latrend(method = lcMethodKML("Y", id = "Id", time = "Time"), latrendData)
plotClusterTrajectories(model)

# show assigned trajectories
plotClusterTrajectories(model, trajectories = TRUE)

# show 95th percentile observation interval
plotClusterTrajectories(model, trajectories = "95pct")

# show observation standard deviation
plotClusterTrajectories(model, trajectories = "sd")

# show observation standard error
plotClusterTrajectories(model, trajectories = "se")

# show observation range
plotClusterTrajectories(model, trajectories = "range")
}
\seealso{
\link{clusterTrajectories} \link{plotFittedTrajectories} \link{plotTrajectories} \link{plot}
}
