% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodStratify.R
\name{lcMethodStratify}
\alias{lcMethodStratify}
\title{Specify a stratification method}
\usage{
lcMethodStratify(
  response,
  stratify,
  center = meanNA,
  nClusters = NaN,
  clusterNames = NULL,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  name = "stratify"
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{stratify}{An \code{expression} returning a \code{number} or \code{factor} value per trajectory, representing the cluster assignment. Alternatively, a \code{function} can be provided that takes separate trajectory \code{data.frame} as input.}

\item{center}{The \code{function} for computing the longitudinal cluster centers, used for representing the cluster trajectories.}

\item{nClusters}{The number of clusters. This is optional, as this can be derived from the largest assignment number by default, or the number of \code{factor} levels.}

\item{clusterNames}{The names of the clusters. If a \code{factor} assignment is returned, the levels are used as the cluster names.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{name}{The name of the method.}
}
\description{
Specify a stratification method
}
\examples{
data(latrendData)
# Stratification based on the mean response level
method <- lcMethodStratify(
  "Y",
  mean(Y) > 0,
  clusterNames = c("Low", "High"),
  id = "Id",
  time = "Time"
)
model <- latrend(method, latrendData)
summary(model)

# Stratification function
stratfun <- function(trajdata) {
   trajmean <- mean(trajdata$Y)
   factor(
     trajmean > 1.7,
     levels = c(FALSE, TRUE),
     labels = c("Low", "High")
   )
}
method <- lcMethodStratify("Y", stratfun, id = "Id", time = "Time")

# Multiple clusters
stratfun3 <- function(trajdata) {
   trajmean <- mean(trajdata$Y)
   cut(
     trajmean,
     c(-Inf, .5, 2, Inf),
     labels = c("Low", "Medium", "High")
   )
}
method <- lcMethodStratify("Y", stratfun3, id = "Id", time = "Time")
}
\seealso{
Other lcMethod implementations: 
\code{\link{getArgumentDefaults}()},
\code{\link{getArgumentExclusions}()},
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}}
}
\concept{lcMethod implementations}
