% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Col.R
\name{Col}
\alias{Col}
\title{Generate a transparent RGB color}
\usage{
Col(col, alpha = 0.2, locate = 0)
}
\arguments{
\item{col}{Color (numeric or character)}

\item{alpha}{Degree of transparency (0,1)}

\item{locate}{Choose colour (with mouse)}
}
\value{
A character vector with elements of 7 or 9 characters, '"\#"'
 followed by the red, blue, green and optionally alpha values in
hexadecimal (after rescaling to '0 ... 255').
}
\description{
This function transforms a standard color (e.g. "red") into an
transparent RGB-color (i.e. alpha-blend<1).
}
\details{
This only works for certain graphics devices (Cairo-X11 (x11 as of R>=2.7), quartz, pdf, ...).
}
\examples{
plot(runif(1000),cex=runif(1000,0,4),col=Col(c("darkblue","orange"),0.5),pch=16)
}
\author{
Klaus K. Holst
}
\keyword{color}

