% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kill.R
\name{rmvar}
\alias{rmvar}
\alias{rmvar<-}
\alias{kill}
\alias{kill<-}
\title{Remove variables from (model) object.}
\usage{
rmvar(x, ...) <- value
}
\arguments{
\item{x}{Model object}

\item{\dots}{additional arguments to lower level functions}

\item{value}{Vector of variables or formula specifying which nodes to
remove}
}
\description{
Generic method for removing elements of object
}
\examples{
m <- lvm()
addvar(m) <- ~y1+y2+x
covariance(m) <- y1~y2
regression(m) <- c(y1,y2) ~ x
### Cancel the covariance between the residuals of y1 and y2
cancel(m) <- y1~y2
### Remove y2 from the model
rmvar(m) <- ~y2

}
\seealso{
\code{cancel}
}
\author{
Klaus K. Holst
}
\keyword{models}
\keyword{regression}
