% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetrize.R
\name{symmetrize}
\alias{symmetrize}
\title{Symmetrize a Matrix}
\usage{
symmetrize(M, update.upper = TRUE)
}
\arguments{
\item{M}{a matrix}

\item{update.upper}{should the upper extra diagonal terms be updated using the lower extra diagonal terms?}
}
\description{
Complete the upper (or lower) extra-diagonal terms  in order to obtain a symmetric matrix.
}
\examples{
M <- matrix(NA, 4, 4)
M[lower.tri(M)] <- 1:6

symmetrize(M, update.upper = TRUE) # good

M[upper.tri(M, diag = FALSE)] <- M[lower.tri(M, diag = FALSE)]
M # wrong
}
