% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-nobs2.R
\name{nobs2}
\alias{nobs2}
\alias{nobs2.lvmfit}
\alias{nobs2.lvmfit2}
\title{Effective Sample Size.}
\usage{
nobs2(object, ssc, ...)

\method{nobs2}{lvmfit}(object, ssc = lava.options()$ssc, ...)

\method{nobs2}{lvmfit2}(object, ...)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}
}
\value{
Numeric vector of length the number of endogenous variables.
}
\description{
Extract the effective sample size, i.e. sample size minus the loss in degrees of freedom caused by the estimation of the parameters.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the leverage.
}
\seealso{
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{extractor}
\keyword{smallSampleCorrection}
