% Generated by roxygen2: do not edit by hand
% Please edit documentation in www.vantharp.com/>
\name{mt_make_model}
\alias{mt_make_model}
\title{Function to train Deep Learning Classification model for Market Type recognition}
\usage{
mt_make_model(indicator_dataset, num_bars, path_model, path_data)
}
\arguments{
\item{indicator_dataset}{Dataset containing indicator patterns to train the model}

\item{num_bars}{Number of bars used to detect pattern}

\item{path_model}{Path where the models are be stored}

\item{path_data}{Path where the aggregated historical data is stored, if exists in rds format}
}
\value{
Function is writing file object with the model
}
\description{
Function is training h2o deep learning model to match manually classified patterns of the financial
indicator. Main idea is to be able to detect Market Type by solely relying on the current indicator pattern.
This is in the attempt to evaluate current market type and to use proper trading strategy.

Selected Market Periods according to the theory from Van K. Tharp:
1. Bull normal, BUN
2. Bull volatile, BUV
3. Bear normal, BEN
4. Bear volatile, BEV
5. Sideways quiet, RAN
6. Sideways volatile, RAV
}
\details{
Function is using manually prepared dataset and tries several different random neural network structures.
Once the best neural network is found then the better model is trained and stored.
}
\examples{

\donttest{

library(dplyr)
library(magrittr)
library(readr)
library(h2o)
library(lazytrade)

path_model <- normalizePath(tempdir(),winslash = "/")
path_data <- normalizePath(tempdir(),winslash = "/")

data(macd_ML2)

Sys.sleep(5)

# start h2o engine (using all CPU's by default)
h2o.init()


# performing Deep Learning Regression using the custom function
mt_make_model(indicator_dataset = macd_ML2,
              num_bars = 64,
              path_model = path_model,
              path_data = path_data)

# stop h2o engine
h2o.shutdown(prompt = FALSE)

#set delay to insure h2o unit closes properly before the next test
Sys.sleep(5)

}



}
\author{
(C) 2020 Vladimir Zhbanko
}
