% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcc.R
\name{summary.lcc}
\alias{summary.lcc}
\title{Summarize an lcc object}
\usage{
\method{summary}{lcc}(object, type, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{\link[lcc]{lcc}}, representing a fitted longitudinal concordance correlation function.}

\item{type}{an optional character string specifying the type of output to be returned. If \code{type="model"}, prints the summary of the polynomial mixed-effects regression model. If \code{type="lcc"}, prints the summary of the fitted and sampled values for LCC, LPC, and LA as well as the concordance correlation coefficient between fitted LCC values and sampled values as goodness of fit (gof). Defaults to \code{type="lcc"}.}

\item{...}{not used.}
}
\value{
an object inheriting from class \code{summary.lcc} including: \item{fitted}{the fitted values extracted from the \code{lcc} object.} \item{sampled}{the sampled values extracted from the \code{lcc} object.} \item{gof}{goodness of fit value based on concordance correlation coefficient between fitted and sampled values.}
}
\description{
Additional information about the fit of longitudinal concordance correlation, longitudinal Pearson correlation, and longitudinal accuracy represented by an object of class \code{\link[lcc]{lcc}}. The returned object has a \code{\link[base]{print}} method.
}
\examples{

data(hue)
## Second degree polynomial model with random intercept, slope and
## quadratic term
fm1<-lcc(dataset = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
summary(fm1, type="model")
summary(fm1, type="lcc")
}
\references{
Lin, L. A Concordance Correlation Coefficient to Evaluate Reproducibility. \emph{Biometrics}, 45, n. 1, 255-268, 1989.

Oliveira, T.P.; Hinde, J.; Zocchi S.S. Longitudinal Concordance Correlation Function Based on Variance Components: An Application in Fruit Color Analysis. \emph{Journal of Agricultural, Biological, and Environmental Statistics}, v. 23, n. 2, 233–254, 2018.
}
\seealso{
\code{\link[lcc]{lcc}}.
}
\author{
Thiago de Paula Oliveira, \email{thiago.paula.oliveira@usp.br}, Rafael de Andrade Moral
}
