% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{format_lddf}
\alias{format_lddf}
\title{Format an element of \code{\link{mldest}()} or
\code{\link{sldest}()} into an
upper-triangular matrix.}
\usage{
format_lddf(obj, element = "r2")
}
\arguments{
\item{obj}{An object of class \code{lddf}, usually output from
running either \code{\link{mldest}()} or
\code{\link{sldest}()}.}

\item{element}{Which element in \code{obj} should we format into an
upper-triangular matrix?}
}
\value{
A matrix of the selected elements. Only the upper-triangle of the
matrix is filled. The lower-triangle and the diagonal are \code{NA}'s.
}
\description{
Formats the LD estimates and standard errors output
from running \code{\link{mldest}()} or \code{\link{sldest}()}
into a more conventional upper-triangular matrix.
}
\examples{
set.seed(1)

## Simulate genotypes when true correlation is 0
nloci <- 5
nind  <- 100
K <- 6
nc <- 1
genomat <- matrix(sample(0:K, nind * nloci, TRUE), nrow = nloci)

## Gametic LD estimates
lddf <- mldest(geno = genomat,
               K = K,
               nc = nc,
               type = "gam")

## Obtain the D estimates in matrix form
Dmat <- format_lddf(obj = lddf, element = "D")
Dmat

}
\author{
David Gerard
}
