% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{DcSearch}
\alias{DcSearch}
\title{Discrete Choice Search}
\usage{
DcSearch(
  y,
  x,
  w = NULL,
  xSizes = NULL,
  xPartitions = NULL,
  costMatrices = NULL,
  searchLogit = TRUE,
  searchProbit = FALSE,
  optimOptions = NULL,
  measureOptions = NULL,
  modelCheckItems = NULL,
  searchItems = NULL,
  searchOptions = NULL
)
}
\arguments{
\item{y}{(numeric vector) endogenous data with variables in the columns.}

\item{x}{(numeric matrix) exogenous data with variables in the columns.}

\item{w}{(numeric vector) weights of the observations in \code{y}. null means equal weights.}

\item{xSizes}{(nullable int vector) Number of exogenous variables in the regressions. E.g., c(1,2) means the model set contains all the regressions with 1 and 2 exogenous variables. If null, c(1) is used.}

\item{xPartitions}{(nullable list of int vector) a partition over the indexes of the exogenous variables. No regression is estimated with two variables in the same group. If null, each variable is placed in its own group and the size of the model set is maximized.}

\item{costMatrices}{(list ofnumeric matrix) each cost matrix determines how to score the calculated probabilities. Given the number of choices 'n', a cost matrix is a 'm x n+1' matrix. The first column determines the thresholds. Cells in the j-th column determines the costs corresponding to the (j-1)-th choice in \code{y}. It can be null if it is not selected in \code{measureOptions}.}

\item{searchLogit}{(bool) if \code{TRUE}, logit regressions are added to the model set.}

\item{searchProbit}{(bool) if \code{TRUE}, probit regressions are added to the model set.}

\item{optimOptions}{(list) Newton optimization options. see \code{[GetNewtonOptions()]}. Use null for default values.}

\item{measureOptions}{(nullable list) see \code{[GetMeasureOptions()]}.}

\item{modelCheckItems}{(nullable list) see \code{[GetModelCheckItems()]}.}

\item{searchItems}{(nullable list) see \code{[GetSearchItems()]}.}

\item{searchOptions}{(nullable list) see \code{[GetSearchOptions()]}.}
}
\value{
A list
}
\description{
Discrete Choice Search
}
