% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyprint.R
\name{easyprintMap}
\alias{easyprintMap}
\title{easyprintMap}
\usage{
easyprintMap(map, sizeModes = "A4Portrait", filename = "map")
}
\arguments{
\item{map}{the map widget}

\item{sizeModes}{Must match one of the given \code{sizeMode} names in
\code{\link{easyprintOptions}}. The options are:
\code{CurrentSize}, \code{A4Portrait} or \code{A4Landscape}. If you want to
print the map with a \code{Custom} sizeMode you need to pass the Custom className.
Default is \code{A4Portrait}}

\item{filename}{Name of the file if \code{exportOnly} option is \code{TRUE}.}
}
\value{
A leaflet map object
}
\description{
Print or export a map programmatically (e.g. in a Shiny environment).
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
  library(shiny)
  library(leaflet)
  library(leaflet.extras2)

  ui <- fluidPage(
    leafletOutput("map"),
    selectInput("scene", "Select Scene", choices = c("CurrentSize", "A4Landscape", "A4Portrait")),
    actionButton("print", "Print Map")
  )

  server <- function(input, output, session) {
    output$map <- renderLeaflet({
      input$print
      leaflet() \%>\%
        addTiles() \%>\%
        setView(10, 50, 9) \%>\%
        addEasyprint(options = easyprintOptions(
          exportOnly = TRUE
        ))
    })
    observeEvent(input$print, {
      leafletProxy("map") \%>\%
        easyprintMap(sizeModes = input$scene)
    })
  }

  shinyApp(ui, server)
}
}
\seealso{
Other EasyPrint Functions: 
\code{\link{addEasyprint}()},
\code{\link{easyprintOptions}()},
\code{\link{removeEasyprint}()}
}
\concept{EasyPrint Functions}
