% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync_with.R
\name{syncWith}
\alias{syncWith}
\title{Synchronize multiple maps}
\usage{
syncWith(map, groupname)
}
\arguments{
\item{map}{A leaflet map object created with \code{\link[leaflet]{leaflet}}.}

\item{groupname}{Character string. All maps that use the same group name will
be synchronized.}
}
\value{
The modified leaflet map object.
}
\description{
This function can be used when multiple leaflet maps are displayed on the
same view (for instance in a shiny application or a Rmarkdown document) and
one wants to synchronize their center, zoom and time.

\code{syncWith()} can also be used with basic leaflet maps to synchronize
only their zoom and center.
}
\examples{
if (require(manipulateWidget) & require(leaflet)) {

  # Synchronize zoom and center of basic maps.
  basicMap1 <- leaflet() \%>\% addTiles() \%>\% syncWith("basicmaps")
  basicMap2 <- leaflet() \%>\% addTiles() \%>\% syncWith("basicmaps")
  combineWidgets(basicMap1, basicMap2)

  # Synchronize time step of two maps that represent the evolution of some
  # variable.
  map1 <- leaflet() \%>\% addTiles() \%>\%
    addMinicharts(0, 40, chartdata = 1:10, time = 1:10) \%>\%
    syncWith("maps")
  map2 <- leaflet() \%>\% addTiles() \%>\%
    addMinicharts(0, 40, chartdata = 10:1, time = 1:10) \%>\%
    syncWith("maps")
  combineWidgets(map1, map2)

}

}
