% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_text.R
\name{question_text}
\alias{question_text}
\title{Text box question}
\usage{
question_text(
  text,
  ...,
  correct = "Correct!",
  incorrect = "Incorrect",
  try_again = incorrect,
  allow_retry = FALSE,
  random_answer_order = FALSE,
  placeholder = "Enter answer here...",
  trim = TRUE,
  options = list()
)
}
\arguments{
\item{text}{Question or option text}

\item{...}{answers and extra parameters passed onto \code{\link{question}}.}

\item{correct}{For \code{question}, text to print for a correct answer (defaults
to "Correct!"). For \code{answer}, a boolean indicating whether this answer is
correct.}

\item{incorrect}{Text to print for an incorrect answer (defaults to "Incorrect")
when \code{allow_retry} is \code{FALSE}.}

\item{try_again}{Text to print for an incorrect answer (defaults to "Incorrect")
when \code{allow_retry} is \code{TRUE}.}

\item{allow_retry}{Allow retry for incorrect answers. Defaults to \code{FALSE}.}

\item{random_answer_order}{Display answers in a random order.}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}

\item{trim}{Logical to determine if whitespace before and after the answer should be removed.  Defaults to \code{TRUE}.}

\item{options}{Extra options to be stored in the question object.}
}
\description{
Creates a text box group tutorial quiz question.
}
\examples{
question_text(
  "Please enter the word 'C0rrect' below:",
  answer("correct", message = "Don't forget to capitalize"),
  answer("c0rrect", message = "Don't forget to capitalize"),
  answer("Correct", message = "Is it really an 'o'?"),
  answer("C0rrect ", message = "Make sure you do not have a trailing space"),
  answer("C0rrect", correct = TRUE),
  allow_retry = TRUE,
  trim = FALSE
)
}
\seealso{
\code{\link{question_radio}}, \code{\link{question_checkbox}}
}
