% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dem_error.R
\name{add_dem_error}
\alias{add_dem_error}
\title{Incorporate vertical error into Digital Elevation Model}
\usage{
add_dem_error(dem, rmse, type = "unfiltered", confidence_level)
}
\arguments{
\item{dem}{\code{RasterLayer} (raster package). Digital Elevation Model}

\item{rmse}{\code{numeric}. Vertical Root Mean Square Error of the Digital Elevation Model}

\item{type}{\code{character}. Methods for creating random fields. Argument currently accepts 'unfiltered' or 'autocorrelated'. Default is 'autocorrelated'. See details for more information}

\item{confidence_level}{\code{numeric}. Assuming a normal distribution of vertical error, the supplied rmse can be multipled by the confidence level z score in order to calculate confidence intervals that are used when generating the random error field. The confidence level denotes the probability that the true elevation value for each cell falls within a range of values (i.e. the confidence interval).}
}
\value{
\code{raster} (raster package). Digital Elevation Model with a single realisation of vertical error incorporated
}
\description{
Incorporates vertical error into the supplied Digital Elevation Model.
}
\details{
Digital Elevation Models are representations of the earth's surface (DEM) and are subject to error (Wechsler, 1999). However the impact of the error on the results of analyses is often not evaluated (Hunter and Goodchild, 1997; Wechsler, 1999).

The add_dem_error function with the type argument as 'unfiltered' incorporates vertical error into the supplied Digital Elevation Model by assuming that the error for each cell follows a gaussian (normal) distribution around the measured elevation value and the global Root Mean Square Error (RMSE) estimating the local error variance around this values (Fisher and Tate, 2006). However, this assumes that the vertical error is random and does not show spatial autocorrelation.

The type argument 'autocorrelated' (default) increases the spatial autocorrelation by applying a mean-low-pass 3x3 filter over the surface (Wechsler and Kroll, 2006).

Examples of RMSE for various datasets:

Shuttle Radar Topography Mission (SRTM) has a RMSE of 9.73m

Advanced Spaceborne Thermal Emission and Reflection Radiometer (ASTER) Global Digital Elevation Model (GDEM) has a RMSE of 10.20m

Ordnance Survey OS Terrain 5 has a maximum RMSE of 2.5m

Ordnance Survey OS Terrain 50 has a maximum RMSE of 4m
}
\examples{

r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))

r_error <- add_dem_error(r, rmse = 9.73)
}
\references{
Fisher, P. F., Tate, N. J. (2006). Causes and consequences of error in digital elevation models. Progress in Physical Geography, 30(4), 467-489. \url{https://doi.org/10.1191/0309133306pp492ra}

Hunter, G. J., Goodchild, M. F. (1997). Modeling the uncertainty of slope and aspect estimates derived from spatial databases. Geographical Analysis, 29: 35-49.

Wechsler, S. P. (1999) Digital Elevation Model (DEM) uncertainty: evaluation and effect on topographic parameters In Proceedings of the 1999 ESRI User Conference (available at: \url{https://ibis.geog.ubc.ca/courses/geob370/notes/uncertainty/DEM_uncertainty_wechsler_dissertation.html})

Wechsler, S. P. (2003). Perceptions of Digital Elevation Model Uncertainty by DEM Users, URISA Journal, 15, 57-64.

Wechsler, S. P., Kroll, C. N. (2006). Quantifying DEM Uncertainty and its Effect on Topographic Parameters. Photogrammetric Engineering & Remote Sensing, 72(9), 1081-1090. \url{https://doi.org/10.14358/pers.72.9.1081}

Wechsler, S. P. (2007). Uncertainties associated with digital elevation models for hydrologic applications: a review. Hydrology and Earth System Sciences, 11, 4, 1481-1500. \url{https://doi.org/10.5194/hess-11-1481-2007}
}
\author{
Joseph Lewis
}
