% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.r
\name{reposition_legend}
\alias{reposition_legend}
\title{Reposition a legend onto a panel}
\usage{
reposition_legend(aplot, position = NULL, legend = NULL, panel = "panel",
  x = NULL, y = NULL, just = NULL, name = "guide-box", clip = "on",
  z = Inf, plot = TRUE)
}
\arguments{
\item{aplot}{a ggplot2 or gtable object.}

\item{position}{Where to place the legend in the panel.
Overrules  \code{just} argument.}

\item{legend}{The legend to place, if \code{NULL} (default),
it is extracted from \code{aplot} if
this is a ggplot2 object.}

\item{panel}{Name of panel in gtable. See description.}

\item{x}{horisontal coordinate of legend, with 0 at left.}

\item{y}{vertical coordiante of legend, with 0 at bottom.}

\item{just}{'Anchor point' of legend; it is this point of the legend that is
placed at the \code{x} and \code{y} coordinates.}

\item{name, clip, z}{Parameters forwarded to 
\code{\link[gtable]{gtable_add_grob}}.}

\item{plot}{Logical, when \code{TRUE} (default), draws plot with legend
repositioned on a new page.}
}
\value{
gtable object, invisibly, with legend repositioned.
  Can be drawn with \code{\link[grid]{grid.draw}}.
}
\description{
Repositions a legend onto a panel, by either taking it from the same ggplot,
or by using another. Works on both ggplot2 and gtable objects, and can accept
any grob as legend.
}
\details{
To modify the look of the legend, use themes and the natural ggplot functions
found in \code{\link[ggplot2]{guide_legend}}.

\emph{Positioning} is done by argument \code{position} which places the panel
relative in \code{panel} (see below).
\code{position} resolves to three variables, \code{x}, \code{y}, and \code{just}.
\code{x} and \code{y} is the coordinate in \code{panel}, where the anchorpoint of
the legend (set via \code{just}) is placed.
In other words, \code{just='bottom right'} places the bottom right corner of 
the legend at coordinates \code{(x,y)}.

The positioning can be set by argument \code{position} alone, which can be 
further nudged by setting \code{position}, \code{x}, and \code{y}. 
Alternatively, manually positioning can be obtained by setting arguments.
\code{x}, \code{y}, and \code{just}.

\emph{Panel} name is by default \code{panel}, but when using facets it typically 
takes the form \code{panel-{col}-{row}}, but not for wrapped facets.
Either print result from \code{\link[ggplot2]{ggplotGrob}} or use
\code{\link{gtable_show_names}} to display all the names of the gtable 
object.

\code{panel} takes multiple names, and will then use these components'
extremes for placing the legend.

If \code{panel} is an integer vector of length 2 or 4, these elements are
used directly for top-left and bottom-right coordinates.
}
\examples{
library(ggplot2)
dsamp <- diamonds[sample(nrow(diamonds), 1000), ]
(d <- ggplot(dsamp, aes(carat, price)) +
 geom_point(aes(colour = clarity)))

reposition_legend(d + theme(legend.position='bottom'), 'bottom right')

# To change the orientation of the legend, use theme's descriptors.
reposition_legend(d + theme(legend.position='bottom'), 'top left')

# Use odd specifications, here offset the legend with half its height from the bottom.
reposition_legend(d + theme(legend.position='bottom'), x=0.3, y=0, just=c(0, -0.5))

# For using with facets:
reposition_legend(d + facet_grid(.~cut), 'top left', panel = 'panel-3-1')
}
\seealso{
\code{\link{g_legend}}, \code{\link{grid_arrange_shared_legend}}
}
\author{
Stefan McKinnon Edwards <sme@iysik.com>
}
