% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularizedSmoothSEMInternal.R
\name{.regularizeSmoothSEMInternal}
\alias{.regularizeSmoothSEMInternal}
\title{.regularizeSmoothSEMInternal}
\usage{
.regularizeSmoothSEMInternal(
  lavaanModel,
  penalty,
  weights,
  tuningParameters,
  epsilon,
  tau,
  method = "bfgs",
  modifyModel,
  control,
  notes = NULL
)
}
\arguments{
\item{lavaanModel}{model of class lavaan}

\item{penalty}{string: name of the penalty used in the model}

\item{weights}{labeled vector with weights for each of the parameters in the
model.}

\item{tuningParameters}{data.frame with tuning parameter values}

\item{epsilon}{epsilon > 0; controls the smoothness of the approximation. Larger values = smoother}

\item{tau}{parameters below threshold tau will be seen as zeroed}

\item{method}{optimizer used. Currently only "bfgs" is supported.}

\item{modifyModel}{used to modify the lavaanModel. See ?modifyModel.}

\item{control}{used to control the optimizer. This element is generated with
the controlBFGS function. See ?controlBFGS for more details.}

\item{notes}{option to pass a notes to function. All notes of the current
function will be added}
}
\value{
regularizedSEM
}
\description{
Internal function: This function computes the regularized models
for all smooth penalty functions which are implemented for bfgs.
Use the dedicated penalty functions (e.g., lessSEM::smoothLasso) to penalize
the model.
}
\keyword{internal}
