% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/str_transform.R
\name{str_transform}
\alias{str_transform}
\title{str_transform}
\usage{
str_transform(string, ...)
}
\arguments{
\item{string}{vector. This must be an atomic vector, and will be coerced to
a character vector}

\item{...}{one or more functions to apply to the string}
}
\value{
a character vector
}
\description{
Convert a string by applying one or more str_* functions.
}
\details{
\code{str_transform} applies successive functions to its first argument,
 \code{string}.
}
\examples{
string = c( "catch-22", "finnegans wake" )
  str_transform( string, str_capitalize )

  str_transform( string, str_capitalize, str_delete_nonword )
  str_delete_nonword( str_capitalize( string ) )      # SAME

  \dontrun{
    # magrittr:
    string \%>\% str_capitalize \%>\% str_delete_nonword   # SAME
  }
}
\seealso{
\code{\link{make_str_replace}}
  \code{\link{make_str_delete}}
}

