% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horizon.R
\name{horizon}
\alias{horizon}
\title{Create a function that computes linguistic horizons}
\usage{
horizon(
  context,
  atomic = c("sm", "me", "bi", "lm", "um", "ze", "neg.sm", "neg.me", "neg.bi", "neg.lm",
    "neg.um")
)
}
\arguments{
\item{context}{A context of linguistic expressions (see \code{\link[=ctx3]{ctx3()}}, \code{\link[=ctx5]{ctx5()}}, \code{\link[=ctx3bilat]{ctx3bilat()}} or \code{\link[=ctx5bilat]{ctx5bilat()}})}

\item{atomic}{An atomic expression whose horizon we would like to obtain}
}
\value{
A function of single argument that must be a numeric vector
}
\description{
Based on given \code{context} and \code{atomic} expression, this function returns a function that computes a linguistic
horizon, i.e. a triangular function representing basic limits of what humans treat as "small", "medium", "big" etc.
within given \code{context}. Linguistic horizon stands as a base for creation of linguistic expressions. A linguistic
expression is created by applying a \code{\link[=hedge]{hedge()}} on horizon. (Atomic linguistic expression is created from horizon by
applying an empty (\code{-}) hedge).
}
\details{
The values of the \code{atomic} parameter have the following meaning (in ascending order):
\itemize{
\item \code{neg.bi}: big negative (far from zero)
\item \code{neg.um}: upper medium negative (between medium negative and big negative)
\item \code{neg.me}: medium negative
\item \code{neg.lm}: lower medium negative (between medium negative and small negative)
\item \code{neg.sm}: small negative (close to zero)
\item \code{ze}: zero
\item \code{sm}: small
\item \code{lm}: lower medium
\item \code{me}: medium
\item \code{um}: upper medium
\item \code{bi}: big
}

Based on the context type, the following atomic expressions are allowed:
\itemize{
\item \code{\link[=ctx3]{ctx3()}} (trichotomy): small, medium, big;
\item \code{\link[=ctx5]{ctx5()}} (pentachotomy): small, lower medium, medium, upper medium, big;
\item \code{\link[=ctx3bilat]{ctx3bilat()}} (bilateral trichotomy): negative big, negative medium, negative small,
zero, small, medium, big;
\item \code{\link[=ctx5bilat]{ctx5bilat()}} (bilateral pentachotomy): negative big, negative medium, negative
small, zero, small, medium, big.
}

This function is quite low-level. Perhaps a more convenient way to create linguistic expressions
is to use the \code{\link[=lingexpr]{lingexpr()}} function.
}
\examples{
    plot(horizon(ctx3(), 'sm'), from=-1, to=2)
    plot(horizon(ctx3(), 'me'), from=-1, to=2)
    plot(horizon(ctx3(), 'bi'), from=-1, to=2)

    a <- horizon(ctx3(), 'sm')
    plot(a)
    h <- hedge('ve')
    plot(h)
    verySmall <- function(x) h(a(x))
    plot(verySmall)
}
\seealso{
\code{\link[=ctx3]{ctx3()}}, \code{\link[=ctx5]{ctx5()}}, \code{\link[=ctx3bilat]{ctx3bilat()}}, \code{\link[=ctx5bilat]{ctx5bilat()}}, \code{\link[=hedge]{hedge()}}, \code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
