% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_combination.R
\name{best_combination}
\alias{best_combination}
\title{Best combination of normalization and imputation method}
\usage{
best_combination(data_input, groups)
}
\arguments{
\item{data_input}{Label-free proteomics expression data as a dataframe}

\item{groups}{Group information about the input data}
}
\value{
This function gives the list  which consist of following results.

`Best Combinations`  The best combinations based on each PCV, PEV and PMAD
for the given dataset.

`PCV Result` Values of groupwise PCV, overall PCV, PCV mean, PCV median and
             PCV standard deviation for all combinations.

`PEV Result` Values of groupwise PEV, overall PEV, PEV mean, PEV median and
             PEV standard deviation for all combinations.

`PMAD Result` Values of groupwise PMAD, overall PMAD, PMAD mean, PMAD median
              and PMAD standard deviation for all combinations.

`vsn_data` The `vsn` normalized dataset

`loess_data` The `loess` normalized dataset

`rlr_data` The `rlr` normalized dataset

`vsn_knn_data` The dataset normalized by `vsn` method and missing values imputed
             by `knn` method.
             
`vsn_lls_data` The dataset normalized by `vsn` method and missing values imputed
             by `lls` method.
             
`vsn_svd_data` The dataset normalized by `vsn` method and missing values imputed
             by `svd` method.

`loess_knn_data` The dataset normalized by `loess` method and missing values imputed
             by `knn` method.

`loess_lls_data` The dataset normalized by `loess` method and missing values imputed
             by `lls` method.
             
`loess_svd_data` The dataset normalized by `loess` method and missing values imputed
             by `svd` method.
             
`rlr_knn_data` The dataset normalized by `rlr` method and missing values imputed
             by `knn` method.

`rlr_lls_data` The dataset normalized by `rlr` method and missing values imputed
             by `lls` method.

`rlr_svd_data` The dataset normalized by `rlr` method and missing values imputed
             by `svd` method.
}
\description{
This function will provide the best combinations of normalization
and imputation methods for the user given dataset based on the intragroup
variation evaluation parameters called PCV, PEV and PMAD.
}
\details{
Label-free LC-MS proteomics expression data is often affected by heterogeneity and missing values. 
Normalization and missing value imputation are the commonly used techniques to solve these issues and make the dataset suitable for further downstream analysis. 
This function provides the best combination of normalization and imputation methods for the dataset, choosing from the three normalization methods (vsn, loess, and rlr) and three imputation methods (knn, lls, svd). 
The intragroup variation evaluation measures named pooled co-efficient of variance (PCV), pooled estimate of variance (PEV) and pooled median absolute deviation (PMAD) are used for selecting the best combination of normalization and imputation method for the given dataset.
It will return the best combinations based on each evaluation parameters of
PCV, PEV, and PMAD.

Along with this, the user can get all three normalized datasets, nine combinations of normalized and missing values imputed datasets, and the PCV, PEV, and PMAD result values.
}
\examples{
\donttest{
result <- best_combination(yeast_data, yeast_groups)
result$`Best combinations`
result$`PCV Result`
result$`PMAD Result`
result$`rlr_knn_data`
}
}
\author{
Dr Sudhir Srivastava ("Sudhir.Srivastava@icar.gov.in")

 Kabilan S ("kabilan151414@gmail.com")
}
