% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgcpPredictSpatioTemporal.R
\name{target.and.grad.spatiotemporal}
\alias{target.and.grad.spatiotemporal}
\title{target.and.grad.spatiotemporal function}
\usage{
target.and.grad.spatiotemporal(Gamma, nis, cellarea, rootQeigs, invrootQeigs,
  mu, spatial, logspat, temporal, bt, gt, gradtrunc)
}
\arguments{
\item{Gamma}{current state of the chain, Gamma}

\item{nis}{matrix of cell counts}

\item{cellarea}{area of cells, a positive number}

\item{rootQeigs}{square root of the eigenvectors of the precision matrix}

\item{invrootQeigs}{inverse square root of the eigenvectors of the precision matrix}

\item{mu}{parameter of the latent Gaussian field}

\item{spatial}{spatial at risk function, lambda, interpolated onto correct grid}

\item{logspat}{log of spatial at risk function, lambda*scaleconst, interpolated onto correct grid}

\item{temporal}{fitted temoporal values}

\item{bt}{in Brix and Diggle vector b(delta t)}

\item{gt}{in Brix and Diggle vector g(delta t) (ie the coefficient of R in G(t)), with convention that (deltat[1])=Inf}

\item{gradtrunc}{gradient truncation parameter}
}
\value{
the back-transformed Y, its exponential, the log-target and gradient for use in MALAlgcp
}
\description{
A function to compute the target and gradient for 'spatial only' MALA
}
