% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderFileRotatingTime}
\alias{AppenderFileRotatingTime}
\title{Log to a time-stamped rotating file}
\description{
Log to a time-stamped rotating file

Log to a time-stamped rotating file
}
\seealso{
\link{AppenderFileRotatingDate}, \link{AppenderFileRotating}, \code{\link[rotor:rotate]{rotor::rotate()}}

Other Appenders: 
\code{\link{AppenderBuffer}},
\code{\link{AppenderConsole}},
\code{\link{AppenderFileRotatingDate}},
\code{\link{AppenderFileRotating}},
\code{\link{AppenderFile}},
\code{\link{AppenderTable}},
\code{\link{Appender}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderFile]{lgr::AppenderFile}} -> \code{\link[lgr:AppenderFileRotating]{lgr::AppenderFileRotating}} -> \code{AppenderFileRotating}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{cache_backups}}{\code{TRUE} or \code{FALSE}. If \code{TRUE} (the default) the list of backups is cached,
if \code{FALSE} it is read from disk every time this appender triggers.
Caching brings a significant speedup for checking whether to rotate or
not based on the \code{age} of the last backup, but is only safe if
there are no other programs/functions (except this appender) interacting
with the backups.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AppenderFileRotatingTime$new()}}
\item \href{#method-rotate}{\code{AppenderFileRotatingTime$rotate()}}
\item \href{#method-set_age}{\code{AppenderFileRotatingTime$set_age()}}
\item \href{#method-set_fmt}{\code{AppenderFileRotatingTime$set_fmt()}}
\item \href{#method-set_overwrite}{\code{AppenderFileRotatingTime$set_overwrite()}}
\item \href{#method-set_cache_backups}{\code{AppenderFileRotatingTime$set_cache_backups()}}
\item \href{#method-format}{\code{AppenderFileRotatingTime$format()}}
\item \href{#method-clone}{\code{AppenderFileRotatingTime$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout">}\href{../../lgr/html/Appender.html#method-set_layout}{\code{lgr::Appender$set_layout()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold">}\href{../../lgr/html/Appender.html#method-set_threshold}{\code{lgr::Appender$set_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFile" data-id="show">}\href{../../lgr/html/AppenderFile.html#method-show}{\code{lgr::AppenderFile$show()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="append">}\href{../../lgr/html/AppenderFileRotating.html#method-append}{\code{lgr::AppenderFileRotating$append()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="prune">}\href{../../lgr/html/AppenderFileRotating.html#method-prune}{\code{lgr::AppenderFileRotating$prune()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_backup_dir">}\href{../../lgr/html/AppenderFileRotating.html#method-set_backup_dir}{\code{lgr::AppenderFileRotating$set_backup_dir()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_compression">}\href{../../lgr/html/AppenderFileRotating.html#method-set_compression}{\code{lgr::AppenderFileRotating$set_compression()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_create_file">}\href{../../lgr/html/AppenderFileRotating.html#method-set_create_file}{\code{lgr::AppenderFileRotating$set_create_file()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_file">}\href{../../lgr/html/AppenderFileRotating.html#method-set_file}{\code{lgr::AppenderFileRotating$set_file()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_max_backups">}\href{../../lgr/html/AppenderFileRotating.html#method-set_max_backups}{\code{lgr::AppenderFileRotating$set_max_backups()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFileRotating" data-id="set_size">}\href{../../lgr/html/AppenderFileRotating.html#method-set_size}{\code{lgr::AppenderFileRotating$set_size()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$new(
  file,
  threshold = NA_integer_,
  layout = LayoutFormat$new(),
  filters = NULL,
  age = Inf,
  size = -1,
  max_backups = Inf,
  compression = FALSE,
  backup_dir = dirname(file),
  fmt = "\%Y-\%m-\%d--\%H-\%M-\%S",
  overwrite = FALSE,
  create_file = TRUE,
  cache_backups = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-rotate}{}}}
\subsection{Method \code{rotate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$rotate(force = FALSE, now = Sys.time())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_age"></a>}}
\if{latex}{\out{\hypertarget{method-set_age}{}}}
\subsection{Method \code{set_age()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$set_age(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_fmt"></a>}}
\if{latex}{\out{\hypertarget{method-set_fmt}{}}}
\subsection{Method \code{set_fmt()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$set_fmt(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_overwrite"></a>}}
\if{latex}{\out{\hypertarget{method-set_overwrite}{}}}
\subsection{Method \code{set_overwrite()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$set_overwrite(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_cache_backups"></a>}}
\if{latex}{\out{\hypertarget{method-set_cache_backups}{}}}
\subsection{Method \code{set_cache_backups()}}{
set the \code{cache_backups} flag.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$set_cache_backups(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a \code{logical} scalar}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$format(color = FALSE, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotatingTime$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
