% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{normalize_isbn}
\alias{normalize_isbn}
\title{Attempt to enforce validity and canonical form to an ISBN}
\usage{
normalize_isbn(x, aggressive = TRUE, convert.to.isbn.13 = FALSE)
}
\arguments{
\item{x}{A string}

\item{aggressive}{A logical indicating whether aggressive measures
should be taken to try to get the "ISBN 10"
into a valid form. See "Details" for more info
(default is \code{TRUE})}

\item{convert.to.isbn.13}{A logical indicating whether the ISBN 10
should be converted into an ISBN 13
(default is \code{FALSE})}
}
\value{
Returns valid ISBN if possible, NA if not
}
\description{
Takes a string representation of an ISBN (10 or 13). This function uses
tries to normalize the string as a ISBN 13, then an ISBN 10. If one of
those methods are able to salvage the ISBN, the canonicalized ISBN is
returned. User can specify whether "aggressive"
measures should be taken to salvage the malformed ISBN string.
}
\details{
If \code{aggressive} is TRUE, aggressive measures are taken to
try to salvage the malformed ISBN string. Since this function attempts
to salvage both an ISBN 10 and 13, to learn about examples of the
aggressive methods, see \code{\link{normalize_isbn_10}} and
\code{\link{normalize_isbn_13}}
}
\examples{

normalize_isbn("012491540x")                           # "012491540X"
normalize_isbn("012491540x", convert.to.isbn.13=TRUE)
"9780124915404"

# vectorized
normalize_isbn(c("513213012491540x245",
                 "978966819^*!X7918",
                 NA,
                 "97815724115799781572411579"))
# "012491540X", "9789668197918", NA, "9781572411579"

}
\seealso{
\code{\link{normalize_isbn_10}} \code{\link{normalize_isbn_13}}
}
