% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{unshelf}
\alias{unshelf}
\title{Detach (unload) packages from the search path}
\usage{
unshelf(..., everything = FALSE, also_depends = FALSE, safe = TRUE,
  quiet = TRUE)
}
\arguments{
\item{...}{(Names) Packages as bare names. For packages that come from GitHub, you can
keep the username/package format, or omit the username and provide just the package
name.}

\item{everything}{(Logical) If \code{TRUE}, detach every non-default package including
librarian. Any names in \code{...} are ignored. The default packages can be listed
with \code{getOption("defaultPackages")}.}

\item{also_depends}{(Logical) If \code{TRUE}, also detach the dependencies of the packages
listed in \code{...}. This can be slow.}

\item{safe}{(Logical) If \code{TRUE}, packages won't be detached if they are needed by other
packages that are \strong{not} listed in \code{...}.}

\item{quiet}{(Logical) If \code{FALSE}, show a message when packages can't be detached
because they are still needed by other packages.}
}
\value{
Invisibly returns a named logical vector, where the names are the packages
and \code{TRUE} means that the package was successfully detached.
}
\description{
Packages can be detached by themselves, with their dependencies safely (i.e. as
long as those dependencies are not being used by other packages), or with their
dependencies unsafely (regardless of whether those dependencies are still needed).
All non-default packages can be detached at once too, including Librarian itself.
}
\examples{
\donttest{
# These are the same:

unshelf(janitor, desiderata, purrr)
unshelf(janitor, DesiQuintans/desiderata, purrr)

# unshelf() returns invisibly; bind its output to a variable or access the .Last.value.

print(.Last.value)

#> desiderata    janitor      purrr 
#>       TRUE       TRUE       TRUE 

unshelf(everything = TRUE)
print(.Last.value)

#> librarian testthat
#> TRUE      TRUE
}

}
