% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stable_rnd}
\alias{stable_rnd}
\title{Skew stable distribution random sample generation.}
\usage{
stable_rnd(N, pars, parametrization = 0L)
}
\arguments{
\item{N}{Number of values to generate.}

\item{pars}{Vector with an initial estimation of the parameters. \code{pars_init = c(alpha, beta, sigma, mu)}, where
\itemize{
\item alpha: shape / stability parameter, with 0 < alpha <= 2.
\item beta: skewness parameter, with -1 <= beta <= 1.
\item sigma: scale parameter, with 0 < sigma.
\item mu: location parameter, with mu real.
}}

\item{parametrization}{Parametrization used for the skew stable distribution, as defined by JP Nolan (1997). By default, parametrization = 0.}
}
\value{
A numeric vector.
}
\description{
\code{stable_rnd(N, pars)} generates N random samples of a skew stable distribuiton
with parameters pars = c(alpha, beta, sigma, mu) using the Chambers, Mallows,
and Stuck (1976) method.\cr\cr
}
\examples{
N <- 1000
pars <- c(1.25, 0.95, 1.0, 0.0)
rnd <- stable_rnd(N, pars)

hist(rnd)
}
\references{
Chambers JM, Mallows CL, Stuck BW (1976). A Method for Simulating Stable Random Variables. Journal of the American Statistical Association, 71(354), 340-344. doi:10.1080/01621459.1976.10480344.
}
\author{
Javier Royuela del Val, Federico Simmross Wattenberg and Carlos Alberola López\cr\cr
Maintainer: Javier Royuela del Val \href{mailto:jroyval@lpi.tel.uva.es}{jroyval@lpi.tel.uva.es}
}
\keyword{distribution}
