% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.las.r
\name{plot.LAS}
\alias{plot.LAS}
\alias{plot}
\title{Plot LiDAR data}
\usage{
\method{plot}{LAS}(x, y, color = "Z", colorPalette = height.colors(50),
  bg = "black", trim = 1, backend = c("rgl", "pcv"), ...)
}
\arguments{
\item{x}{An object of the class \code{LAS}}

\item{y}{Unused (inherited from R base)}

\item{color}{characters. The field used to color the points. Default is Z coordinates.}

\item{colorPalette}{characters. a list of colors such as that generated by heat.colors,
topo.colors, terrain.colors or similar functions.  Default is \code{height.colors(50)}
provided by the package \code{lidR}}

\item{bg}{The color for the background. Default is black.}

\item{trim}{numeric. Enables trimming of values when outliers break the color palette range.
Default is 1, meaning that the whole range of values is used for the color palette.
0.9 means that 10\% of the highest values are not used to define the color palette.
In this case values higher than the 90th percentile are set to the highest color.
They are not removed.}

\item{backend}{character. Can be \code{"rgl"} or \code{"pcv"}. If \code{"rgl"} is chosen
the display relies on the \code{rgl} package. If \code{"pcv"} is chosen it relies on the
\code{PointCloudViewer} package which is much more efficient and can handle million of points
using few memory. \code{PointCloudViewer} is not available on CRAN yet and should
be install from github (see. \url{https://github.com/Jean-Romain/PointCloudViewer}).}

\item{\dots}{Supplementary parameters for \link[rgl:points3d]{points3d}}
}
\description{
This functions implements a 3D plot method for LAS objects
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

plot(lidar)

# Outliers of intensity breaks the color range. Use the trim parameter.
plot(lidar, color = "Intensity", colorPalette = heat.colors(50))
plot(lidar, color = "Intensity", colorPalette = heat.colors(50), trim = 0.99)
}
\seealso{
\link[rgl:points3d]{points3d}
\link[lidR:height.colors]{height.colors}
\link[lidR:forest.colors]{forest.colors}
\link[grDevices:heat.colors]{heat.colors}
\link[grDevices:colorRamp]{colorRampPalette}
\link[lidR:LAS]{Class LAS}
}
