% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_metrics.r
\name{entropy}
\alias{entropy}
\title{Normalized Shannon diversity index}
\usage{
entropy(z, by = 1, zmax = NULL)
}
\arguments{
\item{z}{vector of positive z coordinates}

\item{by}{numeric. The thickness of the layers used (height bin)}

\item{zmax}{numeric. Used to turn the function entropy to the function \link[lidR:VCI]{VCI}.}
}
\value{
A number between 0 and 1
}
\description{
A normalized Shannon vertical complexity index. The Shannon diversity index is a measure for
quantifying diversity and is based on the number and frequency of species present. This index,
developed by Shannon and Weaver for use in information theory, was successfully transferred
to the description of species diversity in biological systems (Shannon 1948). Here it is applied
to quantify the diversity and the evenness of an elevational distribution of las points. It
makes bins between 0 and the maximum elevation. If there are negative values the function
returns NA.
}
\examples{
z = runif(10000, 0, 10)

# expected to be close to 1. The highest diversity is given for a uniform distribution
entropy(z, by = 1)

 z = runif(10000, 9, 10)

# Must be 0. The lowest diversity is given for a unique possibility
entropy(z, by = 1)

z = abs(rnorm(10000, 10, 1))

# expected to be between 0 and 1.
entropy(z, by = 1)
}
\references{
Pretzsch, H. (2008). Description and Analysis of Stand Structures. Springer Berlin Heidelberg. http://doi.org/10.1007/978-3-540-88307-4 (pages 279-280)
Shannon, Claude E. (1948), "A mathematical theory of communication," Bell System Tech. Journal 27, 379-423, 623-656.
}
\seealso{
\link[lidR:VCI]{VCI}
}
