% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_area.R
\name{st_area}
\alias{st_area}
\alias{st_area.LAS}
\alias{st_area.LASheader}
\alias{st_area.LAScatalog}
\alias{area}
\alias{area,LAS-method}
\alias{area,LASheader-method}
\alias{area,LAScatalog-method}
\title{Surface covered by a LAS* object}
\usage{
\method{st_area}{LAS}(x, ...)

\method{st_area}{LASheader}(x, ...)

\method{st_area}{LAScatalog}(x, ...)

area(x, ...)

\S4method{area}{LAS}(x, ...)

\S4method{area}{LASheader}(x, ...)

\S4method{area}{LAScatalog}(x, ...)
}
\arguments{
\item{x}{An object of class \code{LAS*}.}

\item{...}{unused.}
}
\value{
numeric. A number in the same units as the coordinate reference system.
}
\description{
Surface covered by a \verb{LAS*} object. The surface covered by a point cloud is mathematically 0.
To compute non zero values the function uses different strategies. The area is computed based on
the number of occupied cells, or on the area of the convex hull of the points depending on the density
and the size of the point cloud. The result is necessarily an approximation that depends on the method
used.\cr For a \code{LAScatalog} it is computed as the sum of the bounding boxes of the files. For
overlapping tiles the value may be larger than the total area covered because some regions are
sampled twice. For a \code{LASheader} it is computed with the bounding box. As a consequence, for the same file
\code{st_area} applied on a LASheader or on a LAS can return slightly different values. \code{st_area()}
extends \code{sf:st_area()}, \code{area()} extends \code{raster:area()}. \code{area()} is provided for backward
compatibility.
}
