% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.detection.R
\name{treeSegmentation}
\alias{treeSegmentation}
\title{Preprocessing and segmentation of raster image for tree identification}
\usage{
treeSegmentation(
  dem,
  nlFilter = "Closing",
  nlSize = 5,
  sigma = 0.3,
  dmin = 0,
  dprop = 0.05,
  hmin = 5,
  crownProp = 0.3,
  crownMinH = 2,
  dtm = NULL
)
}
\arguments{
\item{dem}{raster object or string indicating location of raster file (typically a canopy height model or a digital surface model; in the latter case the dtm parameter should be provided)}

\item{nlFilter}{string. specifies the non-linear filter for image pre-processing, should be an option of function \code{\link{demFiltering}}}

\item{nlSize}{numeric. width of kernel of non-linear filter in pixels}

\item{sigma}{numeric or matrix. if a single number is provided, sigmap is the standard deviation of Gaussian filter in meters, 0 corresponds to no smoothing. In case of matrix, the first column corresponds to the standard deviation of the filter, and the second to thresholds for image values (e.g. a filter of standard deviation specified in line \code{i} is applied to pixels in image which values are between thresholds indicated in lines \code{i} and \code{i+1}). Threshold values should be ordered in increasing order.}

\item{dmin}{numeric. treetop minimum distance to next higher pixel in meters}

\item{dprop}{numeric. number defining the treetop minimum distance as proportion of height to next higher pixel}

\item{hmin}{numeric. minimum treetop height}

\item{crownProp}{numeric. minimum height of tree crown as proportion of treetop height}

\item{crownMinH}{numeric. minimum crown height}

\item{dtm}{raster object or string indicating location of raster file with the terrain model. If provided, the maxima extraction and watershed segmentation are performed on the dem (this avoids the deformation of crown because of the normalisation with terrain), but maxima selection and segment adjustement are performed on 'dem-dtm' because the selection criteria is the height to terrain.}
}
\value{
A RasterStack with 4 layers: selected local maxima (values = distance to higher pixel), segments, non-linear preprocessed dem, smoothed preprocessed dem
}
\description{
global function for preprocessing (filtering), maxima detection and selection, segmentation and segmentation adjustment of a raster image.
}
\examples{
data(chmchablais3)

# tree segmentation
segments <- treeSegmentation(chmchablais3)
segments2<- treeSegmentation(chmchablais3, nlFilter="Median", nlSize=3,
  sigma=cbind(c(0.2,0.8), c(0,15)),dmin=0,dprop=0,hmin=10,crownProp=0.5,crownMinH=5)

# plot initial image segments
raster::plot(chmchablais3, main="Initial image")
raster::plot(segments$smoothed.dem, main="Filtered image")
raster::plot(segments$local.maxima, main="Local maxima")
#
# replace segment with id 0 (not a tree) with NA
segments$segments.id[segments$segments.id==0] <- NA
raster::plot(segments$segments.id \%\% 8 , main="Segments", col=rainbow(8))
#
# plot segmentation with other parameters
segments2$segments.id[segments2$segments.id==0] <- NA
raster::plot(segments2$segments.id \%\% 8, main="Segments2", col=rainbow(8))

}
\references{
Monnet, J.-M. 2011. Using airborne laser scanning for mountain forests mapping: Support vector regression for stand parameters estimation and unsupervised training for treetop detection. Ph.D. thesis. University of Grenoble, France. Section 6.2 \url{https://tel.archives-ouvertes.fr/tel-00652698/document}

Monnet, J.-M., Mermin, E., Chanussot, J., Berger, F. 2010. Tree top detection using local maxima filtering: a parameter sensitivity analysis. Silvilaser 2010, the 10th International Conference on LiDAR Applications for Assessing Forest Ecosystems, September 14-17, Freiburg, Germany, 9 p. \url{https://hal.archives-ouvertes.fr/hal-00523245/document}
}
\seealso{
\code{\link{demFiltering}}, \code{\link{maximaDetection}}, \code{\link{maximaDetection}}, \code{\link{maximaSelection}}, \code{\link{segmentation}}, \code{\link{segAdjust}}, \code{\link{treeExtraction}}
}
