% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.R
\name{tree_segmentation}
\alias{tree_segmentation}
\title{Preprocessing and segmentation of raster image for tree identification}
\usage{
tree_segmentation(dem, dtm = NULL, crown_prop = NULL, crown_hmin = NULL, ...)
}
\arguments{
\item{dem}{raster object or string indicating location of raster file 
(typically a canopy height model or a digital surface model; in the latter 
case the dtm parameter should be provided)}

\item{dtm}{raster object or string indicating location of raster file with 
the terrain model. If provided, the maxima extraction and watershed segmentation 
are performed on the dem (this avoids the deformation of crown because of the 
normalisation with terrain), but maxima selection and segment adjustment are 
performed on 'dem-dtm' because the selection criteria are based on the height to terrain.}

\item{crown_prop}{(deprecated) numeric. (overrides \code{prop} parameter 
passed to \code{\link{seg_adjust}}, for backward compatibility)}

\item{crown_hmin}{(deprecated) numeric. (overrides \code{min.value} parameter 
passed to \code{\link{seg_adjust}}, for backward compatibility)}

\item{...}{arguments passed to functions \code{\link{dem_filtering}}
(e.g. \code{nl_filter}, \code{nl_size}, \code{sigma}), 
\code{\link{maxima_detection}}, \code{\link{maxima_selection}}, 
\code{\link{maxima_selection}} (\code{dmin}: treetop minimum distance to next
higher pixel in meters, \code{dprop}: number defining the treetop minimum 
distance as proportion of its height to next higher pixel, \code{hmin}: 
minimum treetop height), \code{\link{seg_adjust}} (\code{prop}: minimum 
height of tree crown base as proportion of treetop height, \code{min.value}: 
minimum crown base height)}
}
\value{
A SpatRaster with 4 layers: selected local maxima (values = 
distance to higher pixel), segments, non-linear preprocessed dem, smoothed 
preprocessed dem
}
\description{
global function for preprocessing (filtering), maxima detection and selection, 
segmentation and segmentation adjustment of a raster image.
}
\examples{
data(chm_chablais3)
chm_chablais3 <- terra::rast(chm_chablais3)

# tree segmentation
segments <- tree_segmentation(chm_chablais3)
segments2 <- tree_segmentation(chm_chablais3,
  nl_filter = "Median", nl_size = 3,
  sigma = cbind(c(0.2, 0.8), c(0, 15)), dmin = 0, dprop = 0, hmin = 10, 
  crown_prop = 0.5, crown_hmin = 5
)

# plot initial image segments
terra::plot(chm_chablais3, main = "Initial image")
terra::plot(segments$smoothed_dem, main = "Filtered image")
terra::plot(segments$local_maxima, main = "Local maxima")
#
# replace segment with id 0 (not a tree) with NA
segments$segments_id[segments$segments_id == 0] <- NA
terra::plot(segments$segments_id \%\% 8, main = "Segments", col = rainbow(8))
#
# plot segmentation with other parameters
segments2$segments_id[segments2$segments_id == 0] <- NA
terra::plot(segments2$segments_id \%\% 8, main = "Segments2", col = rainbow(8))
}
\references{
Monnet, J.-M. 2011. Using airborne laser scanning for mountain 
forests mapping: Support vector regression for stand parameters estimation 
and unsupervised training for treetop detection. Ph.D. thesis. University of 
Grenoble, France. Section 6.2 
\url{https://theses.hal.science/tel-00652698/document}

Monnet, J.-M., Mermin, E., Chanussot, J., Berger, F. 2010. Tree top detection 
using local maxima filtering: a parameter sensitivity analysis. Silvilaser 2010, 
the 10th International Conference on LiDAR Applications for Assessing Forest 
Ecosystems, September 14-17, Freiburg, Germany, 9 p. 
\url{https://hal.science/hal-00523245/document}
}
\seealso{
\code{\link{dem_filtering}}, \code{\link{maxima_detection}}, 
\code{\link{maxima_selection}}, \code{\link{segmentation}}, 
\code{\link{seg_adjust}}, \code{\link{tree_extraction}},
\code{\link{tree_detection}}
}
