\name{pxt}
\alias{dxt}
\alias{pxt}
\alias{qxt}

\title{
Function to evaluate survival, death probabilities and deaths.
}
\description{
These functions evalutate survival and raw death probabilities between age x and x+t
}
\usage{

dxt(object, x, t)

pxt(object, x, t, fractional = "linear")

qxt(object, x, t, fractional = "linear")
}

\arguments{

  \item{object}{
	A \code{lifetable} object.
}
  \item{x}{
	Age of life X.
}
  \item{t}{
	Period until which the age shall be evaluated. Default value is 1
}

  \item{fractional}{
	Assumptions for fractional age. One of "linear", "hyperbolic", "constant force".
}

}
\details{
	Fractional assumptions are:
		-linear: linear interpolation between consecutive ages.
		-constant force of mortality: constant force of mortality.
		-hyperbolic: Balducci assumptions. See reference book for details.
}
\value{
A numeric value
}
\references{
	Actuarial Mathematics (Second Edition), 1997, by Bowers, N.L., Gerber, H.U., Hickman, J.C., 
	Jones, D.A. and Nesbitt, C.J.
}
\author{
Giorgio A. Spedicato
}
\note{
This function is the core of many other functions.
}

\section{Warning }{
	The function is provided as is, without any warranty regarding the accuracy of calculations. The author disclaims any liability for eventual 
	losses arising from direct or indirect use of this software.
}

\seealso{
 \code{\link{exn}}, \code{\linkS4class{lifetable}}
}
\examples{
	#dxt example
	data(soa08Act)
	dxt(object=soa08Act, x=90, t=2)
	#qxt example
	qxt(object=soa08Act, x=90, t=2)
	#pxt example
	pxt(object=soa08Act, x=90, t=2, "constant force" )
}

