% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_tocsv.R
\name{lr_convert_tocsv}
\alias{lr_convert_tocsv}
\title{Convert spectral data files to csv files}
\usage{
lr_convert_tocsv(
  where = NULL,
  ext = "txt",
  decimal = ".",
  sep = NULL,
  subdir = FALSE,
  cores = NULL,
  ignore.case = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{where}{Folder in which files are located (defaults to current working
directory).}

\item{ext}{File extension to be searched for, without the "." (defaults to
\code{txt}). You can also use a character vector to specify multiple file
extensions.}

\item{decimal}{Character to be used to identify decimal plates
(defaults to \code{.}).}

\item{sep}{Column delimiting characters to be considered in addition to the
default (which are: tab, space, and ";")}

\item{subdir}{Should subdirectories within the \code{where} folder be included in
the search? (defaults to \code{FALSE}).}

\item{cores}{deprecated. See \code{\link[future:plan]{future::plan()}} for more details on how to
customise your parallelisation strategy.}

\item{ignore.case}{Should the extension search be case insensitive? (defaults
to \code{TRUE})}

\item{overwrite}{logical. Should the function overwrite existing files with
the same name? (defaults to \code{FALSE}).}
}
\value{
Convert input files to csv and invisibly return the list of created
file paths
}
\description{
Convert spectral data files to csv files
}
\details{
You can customise the type of parallel processing used by this function with
the \code{\link[future:plan]{future::plan()}} function. This works on all operating systems, as well
as high performance computing (HPC) environment. Similarly, you can customise
the way progress is shown with the \code{\link[progressr:handlers]{progressr::handlers()}} functions
(progress bar, acoustic feedback, nothing, etc.)
}
\section{Warning}{


This step loses all metadata associated to the spectra. This metadata is
critical to ensure reproducibility. We recommended you use
\code{\link[=lr_get_metadata]{lr_get_metadata()}} to extract this information from your raw data.
}

