% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{lr_get_metadata}
\alias{lr_get_metadata}
\title{Extract metadata from spectra files}
\usage{
lr_get_metadata(
  where = getwd(),
  ext = "ProcSpec",
  sep = NULL,
  subdir = FALSE,
  subdir.names = FALSE,
  cores = NULL,
  ignore.case = TRUE
)
}
\arguments{
\item{where}{Folder in which files are located (defaults to current working
directory).}

\item{ext}{File extension to be searched for, without the "." (defaults to
\code{txt}). You can also use a character vector to specify multiple file
extensions.}

\item{sep}{Column delimiting characters to be considered in addition to the
default (which are: tab, space, and ";")}

\item{subdir}{Should subdirectories within the \code{where} folder be included in
the search? (defaults to \code{FALSE}).}

\item{subdir.names}{Should subdirectory path be included in the name of the
spectra? (defaults to \code{FALSE}).}

\item{cores}{deprecated. See \code{\link[future:plan]{future::plan()}} for more details on how to
customise your parallelisation strategy.}

\item{ignore.case}{Should the extension search be case insensitive? (defaults
to \code{TRUE})}
}
\value{
A data.frame containing one file per row and the following columns:
\itemize{
\item \code{name}: File name (without the extension)
\item \code{user}: Name of the spectrometer operator
\item \code{date}: Timestamp of the recording
\item \code{spec_model}: Model of the spectrometer
\item \code{spec_ID}: Unique ID of the spectrometer
\item \code{white_inttime}: Integration time of the white reference (in ms)
\item \code{dark_inttime}: Integration time of the dark reference (in ms)
\item \code{sample_inttime}: Integration time of the sample (in ms)
\item \code{white_avgs}: Number of averaged measurements for the white reference
\item \code{dark_avgs}: Number of averaged measurements for the dark reference
\item \code{sample_avgs}: Number of averaged measurements for the sample
\item \code{white_boxcar}: Boxcar width for the white reference
\item \code{dark_boxcar}: Boxcar width for the dark reference
\item \code{sample_boxcar}: Boxcar width for the sample reference
}
}
\description{
Finds and imports metadata from spectra files in a given location.
}
\details{
You can customise the type of parallel processing used by this function with
the \code{\link[future:plan]{future::plan()}} function. This works on all operating systems, as well
as high performance computing (HPC) environment. Similarly, you can customise
the way progress is shown with the \code{\link[progressr:handlers]{progressr::handlers()}} functions
(progress bar, acoustic feedback, nothing, etc.)
}
\section{Warning}{

\code{white_inttime}, \code{dark_inttime} and \code{sample_inttime} should be equal. The
normalised data may be inaccurate otherwise.
}

\examples{
\donttest{
lr_get_metadata(system.file("testdata", "procspec_files",
                            package = "lightr"),
                ext = "ProcSpec")
}
}
\references{
White TE, Dalrymple RL, Noble DWA, O'Hanlon JC, Zurek DB,
Umbers KDL. Reproducible research in the study of biological coloration.
Animal Behaviour. 2015 Aug 1;106:51-7 (\doi{10.1016/j.anbehav.2015.05.007}).
}
