% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_diff.R
\name{lyl_diff}
\alias{lyl_diff}
\title{Summarize differences in Life Years Lost.}
\usage{
lyl_diff(lyl_population1, lyl_population0, decimals = 2, level = 0.95,
  weights = NA)
}
\arguments{
\item{lyl_population1}{Population of interest: An object of class \code{lyl} or \code{lyl_range} (obtained with
functions \code{lyl} or \code{lyl_range}). Alternatively, an object of class \code{lyl_ci} can be provided for
bootstrapped confidence intervals.}

\item{lyl_population0}{Reference population: An object of class \code{lyl} or \code{lyl_range} (obtained with
functions \code{lyl} or \code{lyl_range}). Alternatively, an object of class \code{lyl_ci} can be provided for
bootstrapped confidence intervals.}

\item{decimals}{Number of decimals to be reported (default is 2).}

\item{level}{Confidence level if \code{lyl_population1} or \code{lyl_population0} is obtained with the \code{lyl_ci}
function (default is 0.95 for 95\% confidence intervals)}

\item{weights}{Vector with age distribution of disease/condition onset to be used when Life Years Lost are estimated
over a range of ages (with \code{lyl_range} function). If weights are not provided (dafault is \code{weights = NA}),
then the differences in Life Years Lost at each age is provided. If weights are provided, then a weighted average is provided.}
}
\value{
A table with the summary of the differences between two populations.
}
\description{
\code{lyl_diff} summarizes differences in estimated Life Years Lost
in two different populations: \code{lyl_estimation} compared to \code{lyl_estimation0}.
}
\examples{
# Load simulated data as example
data(simu_data)

### For the overall population and for those with a disease
diseased <- simu_data[!is.na(simu_data$age_disease), ]

# Estimate remaining life expectancy and Life Years
# Lost due to specific causes of death after age 45
# years and before age 95 years
lyl_estimation0 <- lyl(data = simu_data, t = age_death, status = cause_death,
                       age_specific = 45, tau = 95)
lyl_estimation1 <- lyl(data = diseased, t0 = age_disease,
                       t = age_death, status = cause_death,
                       age_specific = 45, tau = 95)
lyl_diff(lyl_estimation1, lyl_estimation0)

# Calculate bootstrapped confidence interval (3 iterations to test)
lyl_estimation1_ci <- lyl_ci(lyl_estimation1, niter = 3)
\donttest{
lyl_estimation0_ci <- lyl_ci(lyl_estimation0, niter = 3)
lyl_diff(lyl_estimation1_ci, lyl_estimation0_ci)
}

# It is also possible to assume no uncertainty for one of the estimates
lyl_diff(lyl_estimation1_ci, lyl_estimation0)

\donttest{
# Estimate remaining life expectancy and Life Years
# Lost due to specific causes of death after each age
# from 0 to 94 years and before age 95 years
lyl_estimation2 <- lyl_range(data = simu_data, t = age_death, status = cause_death,
                             age_begin = 0, age_end = 94, tau = 95)
lyl_estimation3 <- lyl_range(data = diseased, t0 = age_disease,
                             t = age_death, status = cause_death,
                             age_begin = 0, age_end = 94, tau = 95)
lyl_diff(lyl_estimation3, lyl_estimation2)
lyl_diff(lyl_estimation3, lyl_estimation2, weights = diseased$age_disease)

# Calculate bootstrapped confidence interval (3 iterations to test)
lyl_estimation3_ci <- lyl_ci(lyl_estimation3, niter = 3)
lyl_diff(lyl_estimation3_ci, lyl_estimation2, weights = diseased$age_disease)
}
}
\seealso{
\itemize{
    \item{\code{\link{lyl}} for estimation of Life Years Lost at one specific age.}
    \item{\code{\link{lyl_range}} for estimation of Life Years Lost for a range of different ages.}
}

% @references \itemize{
    % \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition. \emph{In preparation}.}
% }
}
