% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonality.R
\name{get_seasonality}
\alias{get_seasonality}
\title{get_seasonality}
\usage{
get_seasonality(
  data,
  date_col_name,
  date_type = "weekly starting",
  verbose = FALSE,
  keep_dup = FALSE,
  pool_var = NULL
)
}
\arguments{
\item{data}{\code{data.frame} containing data for analysis}

\item{date_col_name}{The date column name as a string}

\item{date_type}{The date column type as either of the following strings:'weekly starting','weekly ending','daily'}

\item{verbose}{A boolean to specify whether to print warnings}

\item{keep_dup}{A boolean to specify whether to keep duplicate columns between seasonal and data}

\item{pool_var}{The pool (group) column name as a string (e.g. 'country')}
}
\value{
\code{data.frame} with added variables
}
\description{
generate seasonality variables
}
\details{
generate seasonality variables from a \code{data.frame} containing a date-type variable.
}
\examples{
read_xcsv("https://raw.githubusercontent.com/paladinic/data/main/ecomm_data.csv") \%>\%
   get_seasonality(date_col_name = 'date')
}
