% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{lma_initdirs}
\alias{lma_initdirs}
\title{Initialize Directories for Dictionaries and Latent Semantic Spaces}
\usage{
lma_initdirs(base = "", dict = "Dictionaries",
  lspace = "Latent Semantic Spaces", link = TRUE)
}
\arguments{
\item{base}{Path to a directory in which to create the \code{dict} and \code{lspace} subdirectories.}

\item{dict}{Path to the dictionaries directory relative to \code{base}.}

\item{lspace}{Path to the latent semantic spaces directory relative to \code{base}.}

\item{link}{Logical; if \code{TRUE} (default), the full \code{dict} and/or \code{lspace} paths exist
(potentially after being created), and they are not \code{'~/Dictionaries'} or \code{'~/Latent Semantic Spaces'}
respectively, junctions (Windows) or symbolic links will be created: \code{~/Dictionaries} \code{<<===>>}
\code{dict} and \code{~/Latent Semantic Spaces} \code{<<===>>} \code{lspace}.}
}
\value{
Paths to the [1] dictionaries and [2] latent semantic space directories, or a single path if only
\code{dict} or \code{lspace} is specified.
}
\description{
Creates directories for dictionaries and latent semantic spaces if needed, sets them as the
\cr \code{lingmatch.dict.dir} and \code{lingmatch.lspace.dir} options if they are not already set,
and creates links to them in their expected locations (\code{'~/Dictionaries'} and
\code{'~/Latent Semantic Spaces'}) by default if applicable.
}
\examples{
\dontrun{

# set up the expected dictionary and latent semantic space directories
lma_initdirs('~')

# set up directories elsewhere, and links to the expected locations
lma_initdirs('d:')

# point options and create links to preexisting directories
lma_initdirs('~/NLP_Resources', 'Dicts', 'Dicts/Embeddings')

# create just a dictionaries directory and set the
# lingmatch.dict.dir option without creating a link
lma_initdirs(dict = 'z:/external_dictionaries', link = FALSE)

}
}
