% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkGRASS.R
\name{linkGRASS7}
\alias{linkGRASS7}
\title{Initializes environment variables and pathes for GRASS7}
\usage{
linkGRASS7(x = NULL, defaultGrass = NULL, searchPath = NULL,
  verSelect = FALSE)
}
\arguments{
\item{x}{raster or sp object}

\item{defaultGrass}{if NULL an automatic search will be performed. You may 
also provide a valid combination as c("C:/OSGeo4W64","grass-7.0.5","osgeo4w")}

\item{searchPath}{path or mounting point that will be searched}

\item{verSelect}{boolean if TRUE you may choose interactively the binary version (if found  more than one),  by default FALSE}
}
\value{
linkGRASS7 initializes the usage of GRASS7.
}
\description{
Initializes the environment and the pathes for 
\href{https://grass.osgeo.org/}{'GRASS GIS 7.x'}  The correct linkage to 'GRASS GIS' is performed by using an existing and valid
 \code{\link{raster}} or \code{\link{sp}} object. \cr
}
\details{
The concept is very straightforward but for an all days usage pretty 
 helpful. You need to provide a \code{\link{raster}} or \code{\link{sp}} spatial object
 which has to be correctly georeferenced. The resulting params will be used
 to initialize a temporary but static 
 \href{https://CRAN.R-project.org/package=rgrass7}{rgrass7} environment.\cr\cr
 If you want speed up the init process (mainly the search over your hard disk) you can provide a correct parameter set. Best way to do so is to call search
}
\note{
'GRASS GIS 7' is excellently supported by the
 \link{rgrass7} wrapper package. Nevertheless 'GRASS GIS' is well known for
 its high demands regarding the correct workspace and environment setup. This
 becomes even worse on 'Windows' platforms or if alternative 'GRASS GIS'
 installations are available. While the setup function
 \code{initGRASS} that is  provided by the \code{\link{rgrass7}} package, works fine under Linux and for known pathes and environmental variables, one
 will find that the integration of a 'Windows' based 'GRASS GIS' especially if
 provided by 'OSGeo4W' \url{http://trac.osgeo.org/osgeo4w/} and/or the parallel
 installations of different software versions will be cumbersome. The function
 \code{linkGRASS7} tries to find all valid 'GRASS GIS' binaries by analyzing
 the startup files of 'GRASS GIS'. After identifying 'GRASS GIS' binaries all
 necessary system variables and settings will be performed.

If you have more than one valid installation you will be ask to select one.
}
\examples{
\dontrun{
# get meuse data
library(sp)
data(meuse) 
coordinates(meuse) <- ~x+y 
proj4string(meuse) <-CRS("+init=epsg:28992") 

# automatic search and find of GRASS binaries if 
# more than one you have to choose. 
linkGRASS7(meuse)
 
# call if you do not have any idea if and where GRASS is installed
# Actually this linking procedure is highly recommended
linkGRASS7(meuse)

# assuming a typical standalone non-OSGeo4W installation
# You must provide at  
linkGRASS7(meuse,c("C:/Program Files/GRASS GIS7.0.5","GRASS GIS 7.0.5","NSIS")) 

# assuming a typical OSGeo4W installation
linkGRASS7(meuse,c("C:/OSGeo4W64","grass-7.0.5","osgeo4W"))

# string for Linux c("/usr/bin","grass72") '
}
}
\author{
Chris Reudenbach
}

